/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HMCPhysicalMem;
import com.ibm.hsc.common.util.HSCVPD;
import java.io.IOException;

public class HMCBios {
    byte[] tables = null;
    long tableLen = 0L;
    int majorVersion = 0;
    int minorVersion = 0;

    public HMCBios() {
        this.readSmbios();
    }

    public boolean isSmbiosPresent() {
        return this.tables != null;
    }

    public int getSmbiosMajorVersion() {
        return this.majorVersion;
    }

    public int getSmbiosMinorVersion() {
        return this.minorVersion;
    }

    public boolean readSmbios() {
        int n = 0;
        long l = 0L;
        try {
            HMCPhysicalMem hMCPhysicalMem = new HMCPhysicalMem();
            byte[] byArray = new byte[65536];
            hMCPhysicalMem.setAddress(983040L);
            hMCPhysicalMem.read(byArray);
            hMCPhysicalMem.close();
            boolean bl = false;
            int n2 = 0;
            while (n2 <= 65520) {
                if (byArray[n2 + 0] == 95 && byArray[n2 + 1] == 68 && byArray[n2 + 2] == 77 && byArray[n2 + 3] == 73 && byArray[n2 + 4] == 95) {
                    n = HSCVPD.MakeUCHAR(byArray[n2 + 7]) * 256 + HSCVPD.MakeUCHAR(byArray[n2 + 6]);
                    l = (long)HSCVPD.MakeUCHAR(byArray[n2 + 11]) * 0x1000000L + (long)HSCVPD.MakeUCHAR(byArray[n2 + 10]) * 65536L + (long)HSCVPD.MakeUCHAR(byArray[n2 + 9]) * 256L + (long)HSCVPD.MakeUCHAR(byArray[n2 + 8]);
                    byte by = 0;
                    int n3 = 0;
                    while (n3 < 15) {
                        by = (byte)(by + byArray[n2 + n3]);
                        ++n3;
                    }
                    if (by == 0) {
                        bl = true;
                        this.minorVersion = HSCVPD.MakeUCHAR(byArray[n2 + 14]) & 0xF;
                        this.majorVersion = HSCVPD.MakeUCHAR(byArray[n2 + 14]) >> 4;
                        if (n2 <= 16 || byArray[n2 - 16 + 0] != 95 || byArray[n2 - 16 + 1] != 83 || byArray[n2 - 16 + 2] != 77 || byArray[n2 - 16 + 3] != 95) break;
                        this.minorVersion = HSCVPD.MakeUCHAR(byArray[n2 - 16 + 7]);
                        this.majorVersion = HSCVPD.MakeUCHAR(byArray[n2 - 16 + 6]);
                        break;
                    }
                }
                n2 += 16;
            }
            if (bl) {
                this.tableLen = n;
                this.tables = new byte[n];
                hMCPhysicalMem = new HMCPhysicalMem();
                hMCPhysicalMem.setAddress(l);
                hMCPhysicalMem.read(this.tables);
                hMCPhysicalMem.close();
                return true;
            }
        }
        catch (IOException iOException) {
            System.out.println("IO Exception...");
        }
        return false;
    }

    public byte[] getTables() {
        return this.tables;
    }

    public long length() {
        return this.tableLen;
    }

    /*
     * Unable to fully structure code
     */
    public String getSmbiosString(int var1_1, int var2_2) {
        if (this.tables == null) {
            return null;
        }
        if (var2_2 < 1) {
            return null;
        }
        var4_3 = HSCVPD.MakeUCHAR(this.tables[var1_1 + 1]);
        var5_4 = var4_3;
        if (this.tables[var1_1 + var5_4] == 0) {
            return null;
        }
        var3_5 = 1;
        ** GOTO lbl19
        {
            if ((long)(var1_1 + var5_4) >= this.tableLen) {
                return null;
            }
            ++var5_4;
            do {
                if (this.tables[var1_1 + var5_4] != 0) continue block0;
                if (this.tables[var1_1 + ++var5_4] == 0) {
                    return null;
                }
                ++var3_5;
lbl19:
                // 2 sources

            } while (var3_5 < var2_2);
        }
        var6_6 = 0;
        while (this.tables[var1_1 + var5_4 + var6_6] != 0) {
            if ((long)(var1_1 + var5_4 + var6_6) >= this.tableLen) {
                return null;
            }
            ++var6_6;
        }
        return new String(this.tables, var1_1 + var5_4, var6_6);
    }

    int nextStruct(int n) {
        if (this.tables == null) {
            return 0;
        }
        if ((long)(n + 1) >= this.tableLen) {
            return 0;
        }
        int n2 = HSCVPD.MakeUCHAR(this.tables[n + 1]);
        int n3 = n + n2;
        while (n3 != 0 && (long)n3 < this.tableLen && (this.tables[n3] != 0 || this.tables[n3 + 1] != 0)) {
            if ((long)n3 >= this.tableLen) {
                return 0;
            }
            ++n3;
        }
        return n3 + 2;
    }

    /*
     * Unable to fully structure code
     */
    public int findNextStruct(int var1_1, int var2_2) {
        if (this.tables == null) {
            return -1;
        }
        var3_3 = 0;
        if (var1_1 == -1 || (var3_3 = this.nextStruct(var1_1)) != 0) ** GOTO lbl9
        return -1;
        while (HSCVPD.MakeUCHAR(this.tables[var3_3]) != var2_2) {
            if ((var3_3 = this.nextStruct(var3_3)) == 0) {
                return -1;
            }
lbl9:
            // 3 sources

            if ((long)var3_3 < this.tableLen) continue;
        }
        if ((long)var3_3 < this.tableLen && HSCVPD.MakeUCHAR(this.tables[var3_3]) == var2_2) {
            return var3_3;
        }
        return -1;
    }

    public int findOEMStruct(String string) {
        if (this.tables == null) {
            return -1;
        }
        int n = 0;
        while ((long)n < this.tableLen) {
            if (HSCVPD.MakeUCHAR(this.tables[n]) >= 128 && this.getSmbiosString(n, 1).equals(string)) {
                return HSCVPD.MakeUCHAR(this.tables[n]);
            }
            if ((n = this.nextStruct(n)) != 0) continue;
            return -1;
        }
        return -1;
    }
}

